﻿//ESTRUCTURAS EXPUESTAS AL EXTERIOR
#ifndef AEROTRI_ESTIMADOR
#define AEROTRI_ESTIMADOR
typedef struct _Estimador{
	uint8m _f_dens;	//0, normal; 1-10: funciones para fotocoordenadas; 11-20: para el apoyo; 21-30: para el GPS, 31-40: para el INS.
						//De momento sólo sirve para calcular _k_σ.
	uint8m _peso1;		//función de peso
	uint8m _p_precision;	//Función de pesos para calcular las precisiones (aún por programar)
	uint8m divide_r;	//0, nunca; 1, en las primeras iteraciones; -1 siempre
	uint8m def_tau;	//0, kσ*sum(p*v^2); 1, kσ*F^{-1}(q_1); 2, kσ*F^{-1}(0.045); -1, a elegir según r.
	float par1, par2;	//Parámetros por si hiciesen falta alguna vez. Probablemente no hagan falta nunca
	float (*f_dens)(float);
	float (*f_peso1)(float, struct _Estimador*);
	float (*p_precision)(float);

	float kσ;
	float kpeso;
} Estimador;
#define default_values_Estimador(e) \
	e._peso1=e._f_dens=0;\
	e.kσ=1

#define ESTIMADOR_MMCC 0
#define ESTIMADOR_AEROTRI_2006 3
typedef struct{
	uint8m tipo_usuario;
	Estimador estimadores[4];	//0: fotocoordenadas; 1: apoyo, 2: GPS, 3: INS.
} Estimador_complejo;

typedef struct _GrupoIter{
	float limite;
	bool8 divide_r;
	uint8m una_de_cada;	//0 significa invertir sólo la primera
	uint8m par;				//Comparar con un par de iteraciones antes
	Estimador_complejo* estim;	//NULL significa mínimo cuadrático
	struct _GrupoIter* siguiente;
} GrupoIter;

typedef struct{
	uint8m ff, f3, u33;
} Profundidad;

typedef struct{
	Profundidad elim,			//para el relleno inicial (topológico) de Boolff /Sb3 /33
					directo,
					inverso;
} Profundidades;

#endif
